function writeToPajek(CIJ,labels,fname,arcs)
% writes a Pajek .net files from a MATLAB matrix
% CIJ = adjacency matrix
% labels = edge labels
% fname = filename minus .net extension
% arcs = 1 produces a directed net (default), arcs = 0 an undirected net

N = size(CIJ,1);
fid = fopen(cat(2,fname,'.net'), 'w');

if nargin == 3
    arcs = 1;
end

% Clear self-loops in adjacency matrix
CIJ(logical(eye(size(CIJ)))) = 0;

%%%VERTICES
fprintf(fid, '*vertices %6i \r\n', N);
for i = 1:N
    fprintf(fid, '%6i "%s" \r\n', i, labels{i});
end

%%%ARCS/EDGES
if arcs
    fprintf(fid, '*arcs \r\n');
else
    fprintf(fid, '*edges \r\n');
end

[I J] = find(CIJ);

for kk = 1:numel(I)
    fprintf(fid, '%6i %6i %6f \r\n', I(kk),J(kk), CIJ(I(kk),J(kk)));
end
% 
% for i = 1:N
%     for j = 1:N
%         if CIJ(i,j) ~= 0
%             fprintf(fid, '%6i %6i %6f \r', [i j CIJ(i,j)]);
%         end
%     end
% end

fclose(fid);

end

